module.exports = (req, res) => {
  const payload = req.body;
  console.log('[CALL] Payload recibido:', JSON.stringify(payload, null, 2));

  const instrucciones = process.env.AI_PROMPT_CALLING_PARTY || 'Actua como un agente de cobranza cordial.';

  return res.json({
    actions: [
      {
        verb: 'listen',
        url: `${process.env.WS_BASE_URL}/audio-stream`, 
        record: true,
        mixType: 'mono',
        sampleRate: 8000,
        bidirectionalAudio: {
          enabled: true,
          streaming: true,
          sampleRate: 8000
        }
      },
      {
        verb: 'llm',
        vendor: 'ultravox',
        model: 'fixie-ai/ultravox-70B',
        auth: {
          apiKey: process.env.ULTRAVOX_API_KEY
        },
        actionHook: `${process.env.HTTP_BASE_URL}/final`,
        eventHook: `${process.env.HTTP_BASE_URL}/event`,
        events: [
          'conversation.item.*',
          'response.audio_transcript.done',
          'input_audio_buffer.committed'
        ],
        llmOptions: {
          response_create: {
            modalities: ['audio'],
            instructions: instrucciones,
            voice: 'Andrea-Spanish',
            output_audio_format: 'audio/ulaw',
            temperature: 0.8
          }
        }
      }
    ]
  });
};
