// routes/http/event-handler.js
const { publish }  = require('../../utils/monitor-hub');   // <-- ajusta si cambia
const { saveEvent } = require('../../db/save-event');         // tu ruta original

module.exports = (req, res) => {
  const payload = req.body;
  const evento = payload?.event || payload?.type || 'evento no especificado';

  console.log('[HTTP][EVENT] Webhook recibido');
  console.log(`[HTTP][EVENT] Evento: ${evento}`);
  console.dir(payload, { depth: null });

  // 1) Emitimos al monitor (p.ej. transcripts u otros eventos)
  //    Le ponemos un 'type' coherente para la grid:
  const evt = { type: evento, ts: Date.now(), ...payload };
  publish(evt);

  // 2) Persistimos en BD (ingest_event maneja 'transcript' si viene como array)
  saveEvent(evt).catch(err => console.error('db save error [event]', err));

  res.sendStatus(204);
};
