const express = require('express');
const router = express.Router();
const ExcelJS = require('exceljs');
const { todayNumbers, getCallsAndTranscriptsToday  } = require('../../db/save-event');
const TranscriptManager = require('../../utils/transcript-manager');



router.get('/today-numbers.xlsx', async (req, res) => {
  try {
    const tz = req.query.tz || 'America/Lima';
    const numbers = await todayNumbers(tz);
    const { calls, transcripts } = await getCallsAndTranscriptsToday(tz);

    const wb = new ExcelJS.Workbook();
    const ws = wb.addWorksheet('Numeros - Hoy');
    ws.columns = [{ header: 'telefono', key: 'telefono', width: 22 }];
    numbers.forEach(n => ws.addRow({ telefono: n }));
    const wsCalls = wb.addWorksheet('Llamadas');
    const wsTranscripts = wb.addWorksheet('Transcripciones');
    

    wsCalls.columns = [
      { header: 'Call SID', key: 'call_sid', width: 30 },
      { header: 'Telfono', key: 'telefono', width: 20 },
      { header: 'Identificacin', key: 'identificacion', width: 20 },
      { header: 'Estado', key: 'final_status', width: 15 },
      { header: 'Inicio', key: 'started_at', width: 20 },
      { header: 'Duracin', key: 'duration', width: 15 },
      { header: 'Turnos', key: 'turn_count', width: 10 },
      
    ];
    
    const callsResult = await pool.query(`
      SELECT c.*, COUNT(ct.id) as turn_count
      FROM telephony.calls c
      LEFT JOIN telephony.call_transcripts ct ON c.call_sid = ct.call_sid
      WHERE c.started_at >= $1 AND c.started_at <= $2
      GROUP BY c.call_sid
      ORDER BY c.started_at DESC
    `, [startDate, endDate]);
    
    callsResult.rows.forEach(call => {
      wsCalls.addRow({
        call_sid: call.call_sid,
        telefono: call.telefono,
        identificacion: call.identificacion,
        final_status: call.final_status,
        started_at: new Date(call.started_at).toLocaleString(),
        duration: call.ended_at ? Math.round((new Date(call.ended_at) - new Date(call.started_at)) / 1000) : 'N/A',
        turn_count: call.turn_count
      });
    });
    
    
    res.setHeader('Content-Type','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    res.setHeader('Content-Disposition','attachment; filename="today_numbers.xlsx"');
    await wb.xlsx.write(res);
    res.end();
    
     const wsCall = wb.addWorksheet('Llamadas (hoy)');
    wsCall.columns = [
      { header: 'call_sid', key: 'call_sid', width: 38 },
      { header: 'telefono', key: 'telefono', width: 18 },
      { header: 'identificacion', key: 'identificacion', width: 18 },
      { header: 'estado_final', key: 'final_status', width: 18 },
      { header: 'sip_final', key: 'final_sip_status', width: 10 },
      { header: 'motivo_sip', key: 'final_sip_reason', width: 24 },
      { header: 'trunk', key: 'trunk', width: 18 },
      { header: 'started_at', key: 'started_at', width: 20 },
      { header: 'answered_at', key: 'answered_at', width: 20 },
      { header: 'ended_at', key: 'ended_at', width: 20 },
      { header: 'duration_s', key: 'duration_s', width: 12 }
    ];
    for (const c of calls) wsCalls.addRow(c);

    // --- Hoja 2: Transcripciones (hoy) ---
    const wsTx = wb.addWorksheet('Transcripciones (hoy)');
    wsTx.columns = [
      { header: 'call_sid', key: 'call_sid', width: 38 },
      { header: 'ts_local', key: 'ts_local', width: 20 },
      { header: 'speaker', key: 'speaker', width: 12 },
      { header: 'message', key: 'message', width: 120 }
    ];
    for (const t of transcripts) wsTx.addRow(t);

    res.setHeader('Content-Type','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    res.setHeader('Content-Disposition','attachment; filename="calls_with_transcripts_today.xlsx"');
    await wb.xlsx.write(res);
    res.end();
    
  } catch (e) {
    req.app.locals.logger.error(e, 'export today numbers error');
    res.status(500).json({ error: 'export_failed' });
  }
});

module.exports = router;
