//file: routes/http/horario.js
const express = require('express');
const fs = require('fs');
const path = require('path');

const router = express.Router();
const CONFIG_PATH = path.join(__dirname, '../../config/horario-atm.json');


const initializeHorarioFile = () => {
  if (!fs.existsSync(CONFIG_PATH)) {
    const defaultHorario = {
      timezone: "America/Lima",
      dias: {
        lunes: { inicio: "09:00", fin: "18:00", activo: true },
        martes: { inicio: "09:00", fin: "18:00", activo: true },
        miercoles: { inicio: "09:00", fin: "18:00", activo: true },
        jueves: { inicio: "09:00", fin: "18:00", activo: true },
        viernes: { inicio: "09:00", fin: "18:00", activo: true },
        sabado: { inicio: "10:00", fin: "14:00", activo: false },
        domingo: { inicio: "00:00", fin: "00:00", activo: false }
      }
    };
    fs.writeFileSync(CONFIG_PATH, JSON.stringify(defaultHorario, null, 2));
    console.log(' Archivo de horario creado:', CONFIG_PATH);
  }
};

initializeHorarioFile();

router.get('/', (req, res) => {
  try {
    if (!fs.existsSync(CONFIG_PATH)) {
      return res.status(404).json({ error: 'Configuracion de horario no encontrada' });
    }
    
    const data = fs.readFileSync(CONFIG_PATH, 'utf8');
    const horario = JSON.parse(data);
    res.json(horario);
  } catch (err) {
    console.error(' Error leyendo horario:', err);
    res.status(500).json({ error: 'Error leyendo configuracion de horario' });
  }
});

router.post('/', (req, res) => {
  const nuevoHorario = req.body;
  
  if (!nuevoHorario?.dias || !nuevoHorario?.timezone) {
    return res.status(400).json({ error: 'Formato invalido: se requieren dias y timezone' });
  }

  try {
    fs.writeFileSync(CONFIG_PATH, JSON.stringify(nuevoHorario, null, 2));
    console.log(' Horario guardado:', { 
      timezone: nuevoHorario.timezone,
      dias: Object.keys(nuevoHorario.dias) 
    });
    
    //  CORREGIDO: Solo un res.json()
    res.json(nuevoHorario);
    
  } catch (err) {
    console.error('❌ Error guardando horario:', err);
    res.status(500).json({ error: 'Error al guardar horario' });
  }
});

module.exports = router;