//file routes/http/index.js

const express = require('express');

const finalHandler = require('./final-handler');
const eventHandler = require('./event-handler');
const statusHandler = require('./status')
const uploadRouter = require('./upload');
const horarioRouter = require('./horario');
const logger = require('../../utils/logger')('index');
const exportRouter = require('./export');
const { authRouter, authenticateToken } = require ('./auth')


module.exports = function (app) {

  app.use('/auth' , authRouter) ;
  
  app.post('/final', finalHandler);
  app.post('/event', eventHandler);
  app.post('/status', statusHandler);

  app.use('/upload', uploadRouter);
  app.use('/horario', horarioRouter);
  app.use('/export', exportRouter);

  
  
  app.use((err, req, res, next) => {
    if (err.message.includes('Missing parameter name')) {
      logger.warn('Ruta mal definida', { error: err.message });
      return res.status(400).json({ error: 'Ruta inválida' });
    }
    next(err);
  });

  app.use((err, req, res, next) => {
    logger.error('Error interno', { 
      error: err.message, 
      stack: err.stack,
      path: req.path 
    });
    res.status(500).json({ error: 'Error interno del servidor' });
  });
};
