// routes/http/status.js
const express = require('express');
const router = express.Router();
const { saveEvent } = require('../../db/save-event');              // tu ruta original
const { publish }  = require('../../utils/monitor-hub');        // <-- ajusta si cambia
const caller = require('../../utils/call-launcher');

/**
 * Recibe actualizaciones del estado de la llamada desde Jambonz.
 * call_status: ringing, answered, completed, failed, etc.
 */
router.post('/', (req, res) => {
  
  const { call_sid, call_status, from, to, duration, sip_status, sip_reason,
          account_sid, application_sid, direction, fs_public_ip, sbc_callid, trace_id } = req.body;


  

  // Evento normalizado para el monitor (lo que verá la grid)
  const evt = {
    type: 'status',
    ts: Date.now(),
    call_sid,
    call_status,
    from,
    to,
    duration,
    sip_status,
    sip_reason,
    account_sid,
    application_sid,
    direction,
    fs_public_ip,
    sbc_callid,
    trace_id
  };
  
    const terminal = ['completed', 'failed', 'busy', 'no-answer', 'canceled', 'ended'];

  
  if (callSid && terminal.includes(st)) {
    caller.notifyCallCompleted(callSid); // ? avisa que terminó
  }


  // 1) Emitir en tiempo real a los monitores


  // 2) Persistir en BD (función PL/pgSQL telephony.ingest_event)
  //    No bloquea la respuesta HTTP
  saveEvent(evt).catch(err => req.app.locals.logger.error(err, 'db save error [status]'));

  req.app.locals.logger.info({ call_sid, call_status, from, to, duration }, '[STATUS] Estado actualizado de llamada');
  res.sendStatus(200);
});

module.exports = router;
