// routes/ws/monitor.js

const { publish, addWS } = require('../../utils/monitor-hub');



module.exports = function ({ logger, wssStream }) {

  wssStream.on('connection', (ws, req) => {

    const { pathname, searchParams } = new URL(req.url, `http://${req.headers.host}`);

    if (pathname !== '/monitor') return;



    const ui = (searchParams.get('ui') || 'web');

    logger.info({ ui }, 'Nuevo monitor conectado');

    addWS(ws);


     ws.send(JSON.stringify({ 
        type: 'connected', 
        ts: Date.now(), 
        ui: ui 
      }));
      
      ws.on('message', async (raw) => {
    try {
      const msg = JSON.parse(raw);
      
      // Comando de transferencia manual desde el UI
      if (msg && msg.cmd === 'transfer' && msg.call_sid) {
        const referTo = msg.referTo || process.env.HUMAN_AGENT_NUMBER;
        
        logger.info(`Transferencia manual solicitada: ${msg.call_sid} -> ${referTo}`);
        
        // Notificar al UI
        ws.send(JSON.stringify({ 
          type: 'transfer_request_sent', 
          call_sid: msg.call_sid, 
          target: referTo, 
          ts: Date.now() 
        }));

        // Ejecutar transferencia
        const fetch = require('node-fetch');
        const httpBase = process.env.HTTP_BASE_URL;
        
        const resp = await fetch(`${httpBase}/api/transfer`, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ 
            call_sid: msg.call_sid, 
            referTo 
          })
        });
        
        const json = await resp.json().catch(() => null);
        
        // Enviar resultado al UI
        ws.send(JSON.stringify({ 
          type: 'transfer_request_result', 
          call_sid: msg.call_sid, 
          ok: resp.ok, 
          body: json || null, 
          ts: Date.now() 
        }));
      }
    } catch (err) {
      console.error('Error en mensaje WebSocket:', err);
    }
  });

    // saludo

    ws.send(JSON.stringify({ type:'connected', ts: Date.now(), ui: searchParams.get('ui')||'web' }));

    logger.info('Monitor conectado');

  });

};



// helper para que otros mdulos emitan

module.exports.emit = (evt) => publish(evt);
