// utils/monitor-hub.js

const wsClients = new Set();

const sseClients = new Set();

const TranscriptManager = require('./transcript-manager');



function addWS(ws, clientInfo = {}) {
  console.log('addWS llamado con clientInfo:', clientInfo); // Debug
  
  // keepalive
  ws.isAlive = true;
  ws.on('pong', () => { 
    console.log('Pong recibido'); // Debug
    ws.isAlive = true; 
  });

  wsClients.add(ws);
  
  ws.on('close', (code, reason) => {
    console.log(`WebSocket cerrado: ${code} - ${reason}`);
    wsClients.delete(ws);
  });

  ws.on('error', (error) => {
    console.error('WebSocket error:', error);
    try { ws.terminate(); } catch {}
    wsClients.delete(ws);
  });

  // Saludo nico con manejo robusto de errores
  try {
    const saludo = JSON.stringify({ 
      type: 'connected', 
      ts: Date.now(), 
      transport: 'ws',
      ui: clientInfo.ui || 'web'
    });
    console.log('Enviando saludo:', saludo); // Debug
    
    if (ws.readyState === 1) { // OPEN
      ws.send(saludo);
    } else {
      console.log('WebSocket no est en estado OPEN');
      ws.terminate();
    }
  } catch (error) {
    console.error('Error enviando saludo:', error);
    try { ws.terminate(); } catch {}
    wsClients.delete(ws);
  }
}



function addSSE(res) {

  res.setHeader('Content-Type', 'text/event-stream; charset=utf-8');
  res.setHeader('Cache-Control', 'no-cache');
  res.setHeader('Connection', 'keep-alive');
  res.flushHeaders?.();
  res.write('retry: 5000\n\n');

  sseClients.add(res);
  res.on('close', () => sseClients.delete(res));



  // saludo

  res.write(`data: ${JSON.stringify({ type:'connected', ts: Date.now(), transport:'sse' })}\n\n`);

}



function publish(evt) {


  if (evt.type === 'transcript' && evt.call_sid) {

    // Guardar transcripcin en la base de datos

    TranscriptManager.saveMessage(evt.call_sid, {

      speaker: evt.speaker || 'BOT',

      message: evt.message || evt.text || '',

      timestamp: evt.timestamp || new Date().toISOString(),

      metadata: {

        confidence: evt.confidence,

        isFinal: evt.isFinal,

        type: evt.type

      }

    }).catch(console.error);

  }



  const data = JSON.stringify(evt);



  // WS (seguro)

  for (const ws of [...wsClients]) {

    if (ws.readyState !== 1) { // OPEN

      try { ws.terminate(); } catch {}

      wsClients.delete(ws);

      continue;

    }

    try {

      ws.send(data);

    } catch (_) {

      try { ws.terminate(); } catch {}

      wsClients.delete(ws);

    }

  }



  // SSE

  for (const res of [...sseClients]) {

    try { res.write(`data: ${data}\n\n`); }

    catch (_) { try { res.end(); } catch {} sseClients.delete(res); }

  }

}



// Heartbeat: pings cada 30s

function startHeartbeat(intervalMs = 30000) {

  setInterval(() => {

    for (const ws of [...wsClients]) {

      if (ws.isAlive === false) {

        try { ws.terminate(); } catch {}

        wsClients.delete(ws);

        continue;

      }

      ws.isAlive = false;

      try { ws.ping(); } catch (_) {

        try { ws.terminate(); } catch {}

        wsClients.delete(ws);

      }

    }

  }, intervalMs);

}



module.exports = { addWS, addSSE, publish, startHeartbeat };

