function detectarFechaPromesa(texto) {
  const fechaISO = texto.match(/\d{4}-\d{2}-\d{2}/); // busca tipo "2025-06-01"
  if (fechaISO) return fechaISO;

  const fechaNatural = texto.match(/(0?[1-9]|[12][0-9]|3[01])\s+(de\s+)?(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i);
  if (fechaNatural) {
    // ejemplo: "15 de junio"
    const [dia, , mes] = fechaNatural;
    const meses = {
      enero: '01', febrero: '02', marzo: '03', abril: '04',
      mayo: '05', junio: '06', julio: '07', agosto: '08',
      septiembre: '09', octubre: '10', noviembre: '11', diciembre: '12'
    };
    const hoy = new Date();
    return `${hoy.getFullYear()}-${meses[mes.toLowerCase()]}-${String(dia).padStart(2, '0')}`;
  }

  return null;
}

function extraerResumenDesdeTranscripcion(transcripts = []) {
  const partes = transcripts
    .filter(t => t.role === 'agent' && t.final)
    .map(t => t.text)
    .filter(Boolean);

  return partes.join(' ');
}

function detectarAcuerdo(texto) {
  const patrones = [
    /acepto/i,
    /haré el pago/i,
    /me comprometo/i,
    /promesa/i,
    /acuerdo/i,
    /cuota/i,
    /sí voy a pagar/i
  ];

  return patrones.some(pat => pat.test(texto));
}

 function construirPayloadATM({ telefono, identificacion, duracionSegundos, transcripciones, cuentasATM = [], metadata = {} }) {
  const resumen = extraerResumenDesdeTranscripcion(transcripciones);
  const huboAcuerdo = detectarAcuerdo(resumen);
  const fechaPromesaDetectada = detectarFechaPromesa(resumen);

  const cuentas = cuentasATM.map(c => c.cuenta);
  const valor_total = cuentasATM.map(c => parseInt(c.mod_init_cta));
  const valor_cuota = cuentasATM.map(c => parseInt(c.mod_init_cta));
  const fechapromesa = fechaPromesaDetectada ? [fechaPromesaDetectada] : undefined;

  const payload = {
    perfil: huboAcuerdo ? 10 : 24,
    cuenta: cuentas,
    gestion: resumen || 'Cliente no respondió con claridad',
    accion: 1,
    tipocontacto: -1,
    telefono,
    identificacion,
    segundostotales: duracionSegundos
  };

  if (huboAcuerdo && fechapromesa) {
    Object.assign(payload, {
      valor_cuota,
      valor_total,
      fechapromesa
    });
  } else if (metadata.motivonopago) {
    payload.motivonopago = metadata.motivonopago;
  }

  return payload;
}

module.exports = {
  construirPayloadATM,
  detectarAcuerdo,
  extraerResumenDesdeTranscripcion
};
