const sessions = new Map();

/**
 * Agrega una nueva sesión.
 * @param {string} callSid
 * @param {object} session
 * @returns {boolean} true si se agregó, false si ya existía
 */
function addSession(callSid, session) {
  if (sessions.has(callSid)) return false;
  sessions.set(callSid, session);
  return true;
}

/**
 * Verifica si existe una sesión.
 * @param {string} callSid
 * @returns {boolean}
 */
function hasSession(callSid) {
  return sessions.has(callSid);
}

/**
 * Obtiene una sesión existente.
 * @param {string} callSid
 * @returns {object|null}
 */
function getSession(callSid) {
  return sessions.get(callSid) || null;
}

/**
 * Elimina una sesión.
 * @param {string} callSid
 */
function removeSession(callSid) {
  sessions.delete(callSid);
}

/**
 * Limpia todas las sesiones.
 */
function clearSessions() {
  sessions.clear();
}

/**
 * Número de sesiones activas.
 * @returns {number}
 */
function sessionCount() {
  return sessions.size;
}

module.exports = {
  addSession,
  hasSession,
  getSession,
  removeSession,
  clearSessions,
  sessionCount
};
