const assert = require('assert');

const UltravoxAdapter = require('./ultravox_s2s');
const {AI_PROMPT_CALLING_PARTY, AI_PROMPT_CALLED_PARTY} = require('./get-prompts');

/**
 * The Switchman class is responsible for switching audio from the jambonz tracks onto the
 * LLM tracks and vice versa for a single conversation
 *
 */
class Switchman {
  constructor(logger, call_sid) {
    this.logger = logger;
    this.call_sid_a = call_sid;

   this.a_adapter = null;
   this.pendingIncomingWs = null; // Jambonz → Ultravox
   this.pendingOutgoingWs = null; // Ultravox → Jambonz

   this._onAdapterReady = () => {
     this.logger.info('[Switchman] Adaptador listo, asociando sockets pendientes si existen');
     if (this.pendingIncomingWs) {
      this.a_adapter.setIncomingJambonzSocket(this.pendingIncomingWs);
      this.pendingIncomingWs = null;
    }
     if (this.pendingOutgoingWs) {
       this.a_adapter.setOutgoingJambonzSocket(this.pendingOutgoingWs);
       this.pendingOutgoingWs = null;
      }
   };
  
  }
  /*addJambonzWebsocket(ws, call_sid) {
    if (call_sid === this.call_sid_a) {
      if (!this.a_adapter) {
        if (process.env.ULTRAVOX_API_KEY) {
          this.a_adapter = new UltravoxAdapter(this.logger, process.env.ULTRAVOX_API_KEY, AI_PROMPT_CALLING_PARTY);
        } else {
          assert.fail('No speech to speech vendor configured');
        }
      }
  
      this.a_adapter.setIncomingJambonzSocket(ws);
    } else {
      if (this.a_adapter) {
        this.a_adapter.setOutgoingJambonzSocket(ws);
      
      } else {
        this.logger.error('Outgoing socket received before adapter initialized');
      }
    }
  }*/
    addJambonzWebsocket(ws, call_sid) {
      if (call_sid === this.call_sid_a) {
        if (!this.a_adapter) {
          if (process.env.ULTRAVOX_API_KEY) {
            this.a_adapter = new UltravoxAdapter(this.logger, process.env.ULTRAVOX_API_KEY, AI_PROMPT_CALLING_PARTY);
            
            // Esperamos a que el adaptador esté listo antes de asignar el socket
   //         this.a_adapter.once('ready', () => {
   //           this.logger.info('[Switchman] Adaptador listo, asociando socket entrante');
   //           this.a_adapter.setIncomingJambonzSocket(ws);
   //         });
   //         this.a_adapter.once('ready', this._onAdapterReady);
   //         this.pendingIncomingWs = ws;
               // Usamos el MISMO socket para IN y OUT (bidireccional)
            this.pendingIncomingWs = ws;
            this.pendingOutgoingWs = ws;
            this.a_adapter.once('ready', this._onAdapterReady);
          } else {
            assert.fail('No speech to speech vendor configured');
          }
        } else {
          // Ya existía el adaptador, pero aún así espera si el ws no está listo
          //if (this.a_adapter.ws?.readyState === 1) {
          //  this.logger.info('[Switchman] Adaptador ya listo, asignando socket entrante directamente');
         //   this.a_adapter.setIncomingJambonzSocket(ws);
         // } else {
        //    this.logger.warn('[Switchman] Adaptador aún no conectado, esperando...');
         //   this.a_adapter.once('ready', () => {
          //    this.a_adapter.setIncomingJambonzSocket(ws);
          //  });
         // }

      /*   if (this.a_adapter.ws?.readyState === 1) {
         this.logger.info('[Switchman] Entrante: adaptador listo → setIncomingJambonzSocket');
         this.a_adapter.setIncomingJambonzSocket(ws);
       } else {
          this.logger.warn('[Switchman] Entrante: adaptador conectando → guardo pendiente');
        this.pendingIncomingWs = ws;
          this.a_adapter.once('ready', this._onAdapterReady);
       }*/

          if (this.a_adapter.ws?.readyState === 1) {
           this.logger.info('[Switchman] A-leg: adaptador listo → IN+OUT en el mismo WS');
          this.a_adapter.setIncomingJambonzSocket(ws);
            this.a_adapter.setOutgoingJambonzSocket(ws);
          } else {
            this.logger.warn('[Switchman] A-leg: adaptador conectando → guardo WS para IN+OUT');
            this.pendingIncomingWs = ws;
            this.pendingOutgoingWs = ws;
            this.a_adapter.once('ready', this._onAdapterReady);
         }
}
      } else {
        // OUTGOING
        if (this.a_adapter) {
         /* if (this.a_adapter.ws?.readyState === 1) {
            this.a_adapter.setOutgoingJambonzSocket(ws);
          } else {
            this.logger.warn('[Switchman] Adaptador aún no conectado para outgoing, esperando...');
            this.a_adapter.once('ready', () => {
              this.a_adapter.setOutgoingJambonzSocket(ws);
            });
          }*/
        if (this.a_adapter.ws?.readyState === 1) {
          this.logger.info('[Switchman] Saliente: adaptador listo → setOutgoingJambonzSocket');
          this.a_adapter.setOutgoingJambonzSocket(ws);
        } else {
          this.logger.warn('[Switchman] Saliente: adaptador conectando → guardo pendiente');
          this.pendingOutgoingWs = ws;
          this.a_adapter.once('ready', this._onAdapterReady);
       }
        } else {
          this.logger.error('Outgoing socket received before adapter initialized');
        }
      }
    }
    
  

  close() {
  if (this.a_adapter) {
    if (this.a_adapter.ws?.readyState === 1 || this.a_adapter.ws?.readyState === 0) {
      this.a_adapter.ws.close(); // cierra conexión Ultravox WebSocket
    }

    // Cierra sockets de Jambonz si están activos
    if (this.a_adapter.ws_jambonz_in?.readyState === 1 || this.a_adapter.ws_jambonz_in?.readyState === 0) {
      this.a_adapter.ws_jambonz_in.close();
    }
    if (this.a_adapter.ws_jambonz_out?.readyState === 1 || this.a_adapter.ws_jambonz_out?.readyState === 0) {
      this.a_adapter.ws_jambonz_out.close();
    }

    this.a_adapter = null;
  }

  this.logger.info(`[Switchman] Adaptador y sockets cerrados para callSid=${this.call_sid_a}`);
}

}

module.exports = Switchman;




// file: utils/switchman.js
/***const UltravoxAdapter = require('./ultravox_s2s');
const fs = require('fs');
const path = require('path');

class Switchman {
  constructor(logger, callSid) {
    this.logger = logger;
    this.callSid = callSid;
    this.session = null;
    this.ultravoxAdapter = null;
    this.jambonzSocket = null;
    this.incomingAudioStream = null;
    this.outgoingAudioStream = null;
    this.logger = logger;
    this.audioBuffer = [];
  }

  setSession(session) {
    this.session = session;
  }

  setJoinUrl(joinUrl) {
    if (!this.ultravoxAdapter) {
      this.ultravoxAdapter = new UltravoxAdapter(this.logger, process.env.ULTRAVOX_API_KEY, null, 'fixie-ai/ultravox', 'Andrea-Spanish');
    }
    this.ultravoxAdapter.setJoinUrl(joinUrl);
  }

  setOutgoingJambonzSocket(ws) {
    this.jambonzSocket = ws;
    this.logger.info(`[Switchman] Socket Jambonz conectado para callSid=${this.callSid}`);
    this.startAudioForwarding();
  }

  
  setIncomingJambonzSocket(ws) {
    this.jambonzSocket = ws;
    this.logger.info(`[Switchman] Socket Jambonz (entrante) conectado para callSid=${this.callSid}`);
  }

  async initializeUltravoxAdapter() {
    if (!this.ultravoxAdapter) {
      this.logger.error(`[Switchman] UltravoxAdapter no inicializado en callSid=${this.callSid}`);
      return;
    }
  
    if (!this.ultravoxAdapter.joinUrl) {
      this.logger.error(`[Switchman] No joinUrl disponible para conectar adaptador Ultravox en callSid=${this.callSid}`);
      return;
    }
  
    if (this.ultravoxAdapter.ws && this.ultravoxAdapter.ws.readyState === 1) {
      this.logger.info(`[Switchman] WebSocket Ultravox ya estaba conectado para callSid=${this.callSid}`);
      return;
    }
  
    // Si el WebSocket está en otro estado, ciérralo limpio
    if (this.ultravoxAdapter.ws && (this.ultravoxAdapter.ws.readyState === 2 || this.ultravoxAdapter.ws.readyState === 3)) {
      try {
        this.logger.warn(`[Switchman] Cerrando WebSocket Ultravox anterior para callSid=${this.callSid}`);
        this.ultravoxAdapter.ws.terminate(); // kill inmediatamente
      } catch (e) {
        this.logger.error(`[Switchman] Error cerrando WebSocket previo: ${e.message}`);
      }
    }
  
    // Pequeño delay de estabilidad
    await new Promise(resolve => setTimeout(resolve, 1000)); 
  
    await this.ultravoxAdapter.connect();
    this.logger.info(`[Switchman] Adaptador Ultravox conectado para callSid=${this.callSid}`);
  
    if (this.ultravoxAdapter.ws.readyState === 1 && this.jambonzSocket?.readyState === 1) {
      this.startAudioForwarding();
    }
  }
  ***/

  /*async initializeUltravoxAdapter() {
    if (this.ultravoxAdapter && this.ultravoxAdapter.joinUrl) {
      await this.ultravoxAdapter.connect();
      this.logger.info(`[Switchman] Adaptador Ultravox conectado para callSid=${this.callSid}`);
  
      if (this.ultravoxAdapter?.ws?.readyState === 1) {
        this.logger.info(`[Switchman] WebSocket Ultravox listo para callSid=${this.callSid}`);
        this.onUltravoxConnected();
      } else {
        this.ultravoxAdapter.ws.on('open', () => {
          this.logger.info(`[Switchman] WebSocket Ultravox abierto para callSid=${this.callSid}`);
          this.onUltravoxConnected();
        });
      }
  
      this.startAudioForwarding();
    } else {
      this.logger.error(`[Switchman] No joinUrl disponible para conectar adaptador Ultravox en callSid=${this.callSid}`);
    }
  }*/

  /*startAudioForwarding() {
    if (!this.ultravoxAdapter?.ws || !this.jambonzSocket) {
      this.logger.warn(`[Switchman] No sockets disponibles aún para forwarding en callSid=${this.callSid}`);
      return;
    }

    // Crear streams para grabación
    const recordingsPath = path.resolve(__dirname, '..', 'recordings');
    if (!fs.existsSync(recordingsPath)) fs.mkdirSync(recordingsPath);

    this.outgoingAudioStream = fs.createWriteStream(path.join(recordingsPath, `ultravox-out-audio-${this.callSid}.raw`));
    this.incomingAudioStream = fs.createWriteStream(path.join(recordingsPath, `jambonz-in-audio-${this.callSid}.raw`));

    // Audio que viene de Ultravox → enviar a Jambonz
    this.ultravoxAdapter.ws.on('message', (msg, isBinary) => {
      if (isBinary) {
        this.outgoingAudioStream.write(msg);
        if (this.jambonzSocket.readyState === 1) {
          this.jambonzSocket.send(msg);
        }
      }
    });

    // Audio que viene de Jambonz → grabar (por ahora solo grabar, no enviar)
    this.jambonzSocket.on('message', (msg, isBinary) => {
      if (isBinary) {
        this.incomingAudioStream.write(msg);
        if (this.ultravoxAdapter?.ws?.readyState === 1) {
           this.ultravoxAdapter.ws.send(msg);
           }
      }
    });
  }*/
 /***startAudioForwarding() {
  const isUltravoxOpen = this.ultravoxAdapter?.ws?.readyState === 1;
  const isJambonzOpen = this.jambonzSocket?.readyState === 1;

  if (!isUltravoxOpen || !isJambonzOpen) {
    this.logger.warn(`[Switchman] Sockets no están listos (Ultravox: ${isUltravoxOpen}, Jambonz: ${isJambonzOpen}) para forwarding en callSid=${this.callSid}`);
    return;
  }

  if (this.forwardingStarted) return;
  this.forwardingStarted = true;

  const recordingsPath = path.resolve(__dirname, '..', 'recordings');
  if (!fs.existsSync(recordingsPath)) fs.mkdirSync(recordingsPath);

  this.outgoingAudioStream = fs.createWriteStream(path.join(recordingsPath, `ultravox-out-audio-${this.callSid}.raw`));
  this.incomingAudioStream = fs.createWriteStream(path.join(recordingsPath, `jambonz-in-audio-${this.callSid}.raw`));

  this.ultravoxAdapter.ws.on('message', (msg, isBinary) => {
    if (isBinary) {
      this.outgoingAudioStream.write(msg);
      this.jambonzSocket.send(msg);
    }
  });

  this.jambonzSocket.on('message', (msg, isBinary) => {
    if (isBinary) {
      this.incomingAudioStream.write(msg);
      this.ultravoxAdapter.ws.send(msg);
    }
  });

  this.logger.info(`[Switchman] Audio forwarding iniciado para callSid=${this.callSid}`);
}

  addJambonzWebsocket(ws, callSid) {
    this.logger.info(`[Switchman] WebSocket Jambonz añadido para callSid=${callSid}`);
    this.setOutgoingJambonzSocket(ws); 
  }

  forwardIncomingAudioFromUltravox(msg) {
    if (this.ultravoxAdapter?.ws?.readyState === 1) {
      this.ultravoxAdapter.ws.send(msg);
    } else {
      //this.logger.warn(`[Switchman] No Ultravox WebSocket para reenviar audio en callSid=${this.callSid}`);
      this.audioBuffer.push(msg);
    }
  }

  onUltravoxConnected() {
    this.logger.info(`[Switchman] Enviando ${this.audioBuffer.length} mensajes de audio en buffer para callSid=${this.callSid}`);
    while (this.audioBuffer.length > 0) {
      const msg = this.audioBuffer.shift();
      this.logger.debug(`[Switchman] Enviando mensaje de ${msg.length} bytes desde buffer para callSid=${this.callSid}`);
      this.ultravoxAdapter.ws.send(msg);
    }
  }

  close() {
    if (this.ultravoxAdapter) {
      this.ultravoxAdapter.close();
      this.ultravoxAdapter = null;
    }
    if (this.incomingAudioStream) {
      this.incomingAudioStream.end();
    }
    if (this.outgoingAudioStream) {
      this.outgoingAudioStream.end();
    }
    this.logger.info(`[Switchman] Adaptador Ultravox cerrado para callSid=${this.callSid}`);
  }
}

module.exports = Switchman;***/
