import { CronExpression, CronExpressionOptions } from './CronExpression';
export declare enum PredefinedExpressions {
    '@yearly' = "0 0 0 1 1 *",
    '@annually' = "0 0 0 1 1 *",
    '@monthly' = "0 0 0 1 * *",
    '@weekly' = "0 0 0 * * 0",
    '@daily' = "0 0 0 * * *",
    '@hourly' = "0 0 * * * *",
    '@minutely' = "0 * * * * *",
    '@secondly' = "* * * * * *",
    '@weekdays' = "0 0 0 * * 1-5",
    '@weekends' = "0 0 0 * * 0,6"
}
export declare enum CronUnit {
    Second = "Second",
    Minute = "Minute",
    Hour = "Hour",
    DayOfMonth = "DayOfMonth",
    Month = "Month",
    DayOfWeek = "DayOfWeek"
}
export declare enum Months {
    jan = 1,
    feb = 2,
    mar = 3,
    apr = 4,
    may = 5,
    jun = 6,
    jul = 7,
    aug = 8,
    sep = 9,
    oct = 10,
    nov = 11,
    dec = 12
}
export declare enum DayOfWeek {
    sun = 0,
    mon = 1,
    tue = 2,
    wed = 3,
    thu = 4,
    fri = 5,
    sat = 6
}
export type RawCronFields = {
    second: string;
    minute: string;
    hour: string;
    dayOfMonth: string;
    month: string;
    dayOfWeek: string;
};
/**
 * Static class that parses a cron expression and returns a CronExpression object.
 * @static
 * @class CronExpressionParser
 */
export declare class CronExpressionParser {
    #private;
    /**
     * Parses a cron expression and returns a CronExpression object.
     * @param {string} expression - The cron expression to parse.
     * @param {CronExpressionOptions} [options={}] - The options to use when parsing the expression.
     * @param {boolean} [options.strict=false] - If true, will throw an error if the expression contains both dayOfMonth and dayOfWeek.
     * @param {CronDate} [options.currentDate=new CronDate(undefined, 'UTC')] - The date to use when calculating the next/previous occurrence.
     *
     * @returns {CronExpression} A CronExpression object.
     */
    static parse(expression: string, options?: CronExpressionOptions): CronExpression;
}
