
# Contributing to node-localstorage

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. The community looks forward to your contributions. 🎉

## I Have a Question

Before you ask a question read the available [documentation](https://github.com/lmaccherone/node-localstorage/blob/master/README.md) and search for existing [issues](https://github.com/lmaccherone/node-localstorage/issues) that might help you. In case you have found a suitable issue but need more clarification, you can write your question as a comment in the issue.

If you then still need to ask a question, then feel free open an [Issue](https://github.com/lmaccherone/node-localstorage/issues/new).

We will respond to the issue as soon as possible.


## I Want To Contribute

> ### Legal Notice 
> Contributions must be free of any encumberance. Contributions are an attestation that you have the necessary authority to contribute it under the project license. By making a contribution of code or documentation, you agree to donate rights to the contribution to the project for the project to do with it whatever it wishes including but not limited to offering the project under a different license.

### Reporting Bugs

> #### Security Issues 
> You must never report security related issues, including vulnerabilities or the presence of sensitive information, to the issue tracker or elsewhere in public. See [SECURITY.md](https://github.com/lmaccherone/node-localstorage/blob/master/SECURITY.md) for instructions on how to report security issues.

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://github.com/lmaccherone/node-localstorage/issues/new).
- Explain the behavior you would expect and the actual behavior.
- The working agreement for this project is that the first step in fixing a bug is reproducing it in an automated test case, so the ideal bug report includes a failing test case but at the very least should include enough information for someone to reproduce it and write a test case. If you can't reproduce it, we can't fix it.
- Make sure that your preferences are set so that you are notified when the issue is updated. This will allow you to respond to any questions or requests for additional information.


### Suggesting Enhancements

Enhancement suggestions are tracked as [GitHub issues](https://github.com/lmaccherone/node-localstorage/issues).

Steps to suggest an enhancement:

- Make sure that you are using the latest version.
- Read the [documentation](https://github.com/lmaccherone/node-localstorage/blob/master/README.md) carefully and find out if the functionality is already covered, maybe with an optional parameter or configuration.
- Perform a [search](https://github.com/lmaccherone/node-localstorage/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue in support rather than opening a new one.
- Think about whether your idea fits with the scope and goals of the project.
- Open an [Issue](https://github.com/lmaccherone/node-localstorage/issues/new).
- Describe the enhancement and the motivation behind it. If your enhancement targets a minority of users or is backward breaking propose it as optional with additional parameters or configuration.


### Your First  Contribution

Use the steps below to make your first code or documentation contribution to the project:

- Fork the [repository](https://github.com/lmaccherone/node-localstorage/fork) into your account.
- Make your changes in your fork.
- Be sure to keep the style consistent with the existing code or documentation.
- If your contribution adds new functionality, make sure that you add tests for both the happy path and unexpected inputs.
- If your contribution fixes a bug, start by writing a failing test the duplicates the bug, then modify the code so the test no longer fails. Then go back and write more tests to cover any other cases similar to the one you just fixed.


## Attribution
This guide is based on the **contributing-gen**. [Make your own](https://github.com/bttger/contributing-gen)!
