// routes/http/final-handler.js - CORREGIDO
const storage = require('../../utils/storage');
const { publish } = require('../../utils/monitor-hub');
const { saveEvent } = require('../../db/save-event');
const caller = require('../../utils/call-launcher');

module.exports = async (req, res) => {
  const payload = req.body;
  console.log('[FINAL] Payload recibido en /final:', JSON.stringify(payload, null, 2));

  const numero = (() => {
    const to = payload?.to;
    if (typeof to === 'string' && to.startsWith('sip:')) return to.split(':')[1].split('@')[0];
    if (typeof to === 'object' && to?.sipUri?.startsWith('sip:')) return to.sipUri.split(':')[1].split('@')[0];
    return '';
  })();

  const motivo = payload.completion_reason;
  const call_status = payload.call_status;
  const sip_status = payload.sip_status;
  const duration = payload.duration;

  // ========================= CLASIFICACIÓN DEL RESULTADO =========================
  // CORREGIR: usar caller en lugar de calller (typo) y verificar si la función existe
  let clasificacion;
  let resultadoTipo = 'desconocido';
  let fueExitoso = false;
  let esTransferencia = false;

  if (caller.clasificarResultadoLlamada) {
    clasificacion = caller.clasificarResultadoLlamada(numero, call_status, duration, motivo);
    resultadoTipo = clasificacion.tipo;
    fueExitoso = clasificacion.exitoso;
    esTransferencia = clasificacion.tipo === 'transferido';
    console.log(`[CLASIFICACIÓN] ${numero}: ${resultadoTipo} - Éxito: ${fueExitoso} - Reintentar: ${clasificacion.reintentar}`);
  } else {
    // Fallback si no existe la función de clasificación
    console.log('[CLASIFICACIÓN] Función no disponible, usando lógica manual');
    
    if (motivo && (motivo.includes('transfer') || motivo === 'agent_transfer')) {
      resultadoTipo = 'transferido';
      fueExitoso = true;
      esTransferencia = true;
    } else if (call_status === 'completed' && duration > 30) {
      resultadoTipo = 'exitoso';
      fueExitoso = true;
    } else if (call_status === 'completed' && duration <= 30) {
      resultadoTipo = 'cortada';
    } else if (call_status === 'failed') {
      resultadoTipo = 'fallida';
    } else if (call_status === 'busy') {
      resultadoTipo = 'ocupado';
    } else if (call_status === 'no-answer') {
      resultadoTipo = 'no-contesta';
    }
    
    console.log(`[CLASIFICACIÓN MANUAL] ${numero}: ${resultadoTipo} - Éxito: ${fueExitoso}`);
  }

  // ========================= EVENTO ESPECÍFICO =========================
  if (esTransferencia) {
    const transferEvent = {
      type: 'transfer_completed',
      ts: Date.now(),
      call_sid: payload.call_sid,
      telefono: numero,
      transfer_status: 'completed',
      completion_reason: motivo,
      duration: duration
    };
    
    publish(transferEvent);
    saveEvent(transferEvent).catch(err => console.error('db save error [transfer_completed]', err));
    console.log(`[TRANSFER] Llamada ${payload.call_sid} transferida a agente: ${numero}`);
  }

  // ========================= NOTIFICAR COMPLETACIÓN =========================
  if (payload.call_sid && numero) {
    const statusCode = fueExitoso ? 200 : 400;
    caller.notifyCallCompleted(payload.call_sid, numero, statusCode, esTransferencia);
  }

  // ========================= EVENTO FINAL GENERAL =========================
  const evt = {
    type: 'final',
    ts: Date.now(),
    ...payload,
    telefono: numero,
    resultado_tipo: resultadoTipo,
    fue_exitoso: fueExitoso,
    call_status: call_status || 'completed'
  };
  
  publish(evt);
  saveEvent(evt).catch(err => console.error('db save error [final]', err));

  // ========================= REGISTRO PARA REINTENTOS =========================
  if (numero && fueExitoso) {
    try {
      await storage.set(`call_success:${numero}`, {
        resultado: resultadoTipo,
        timestamp: new Date().toISOString(),
        duration: duration,
        call_sid: payload.call_sid
      }, { ttl: 60 * 60 * 24 });
      console.log(`[FINAL] ${resultadoTipo.toUpperCase()} registrado para ${numero}`);
    } catch (err) {
      console.error(`[FINAL] Error guardando resultado para ${numero}`, err);
    }
  }

  console.log(`[FINAL] Procesamiento completado: ${numero} - ${resultadoTipo}`);
  res.sendStatus(200);
};