// file: ws/audio-stream.js

const yardmaster = require('../../utils/yardmaster');
module.exports = function({ logger, wssStream }) {  // Elimina callService si no se usa
  wssStream.on('connection', (ws, req) => {
    try {
      const url = new URL(req.url, `http://${req.headers.host}`);
      console.log("url buscar si pasa el call_sid", url);
      const pathname = url.pathname;
      
      if(pathname !== '/audio-stream') return;
      const query = url.searchParams;
      const callSid = query.get('callSid');
      const parentCallSid = query.get('parentCallSid');

      if (!callSid) {
        logger.warn('Conexión rechazada: callSid requerido');
        return ws.close(1003, 'callSid required');
      }

      logger.info(`Nueva conexión WS para ${callSid}`);
      
      // Configuración básica de WebSocket
      ws.on('error', (err) => logger.error(`WS error: ${err.message}`, { callSid }));
      ws.on('close', () => logger.info(`Conexión cerrada: ${callSid}`));

      // Confirmación de conexión
      ws.send(JSON.stringify({ 
        event: 'connected',
        callSid,
        timestamp: Date.now() 
      }));

      // Manejo de mensajes (si es necesario)
      ws.on('message', (message) => {
        logger.debug(`Mensaje recibido de ${callSid}: ${message}`);
        // Procesar mensaje aquí
      });

      // Registrar en yardmaster
      yardmaster.addJambonzWebsocket(ws, callSid, parentCallSid);

    } catch (err) {
      logger.error(`Error en conexión WS: ${err.message}`);
      ws.close(1011, 'Internal error');
    }
  });
};
/*
module.exports = function({ logger, callService, wssStream }) {

  wssStream.on('connection', (ws, req) => {
    const url = new URL(req.url, `http://${req.headers.host}`);
    const callSid = url.searchParams.get('callSid');
    const parentCallSid = url.searchParams.get('parentCallSid');

    if (!callSid) {
        logger.warn('Conexión rechazada: callSid requerido');
        return ws.close(1003, 'callSid required');
      }

    if (!yardmaster.hasSession(parentCallSid || callSid)) {
      logger.info(`creating new Yardmaster session for ${callSid}`);
      yardmaster.addSession(parentCallSid || callSid);
    }

    yardmaster.addJambonzWebsocket(ws, callSid, parentCallSid);
  });

  callService.on('session:new', (session) => {
    logger.info(`[CALL] Nueva llamada entrante: ${session.call_sid}`);
  });

  callService.on('session:reconnect', (session) => {
    logger.info(`[CALL] Reconexion de llamada: ${session.call_sid}`);
  });

  callService.on('session:end', (session) => {
    logger.info(`[CALL] Fin de llamada: ${session.call_sid}`);
    yardmaster.close(session.call_sid);
  });
};
*/