const { detenerEjecucionLlamadas } = require('../../utils/call-launcher');
const safeClose = require('../../utils/safe-close');
const yardMaster = require('../../utils/yardmaster');
//const { construirPayloadATM } = require('../../utils/post-llamada');
const atmService =  require('../../services/atm-service');

const { 
  enviarResultadoATM, 
  obtenerTokenATM, 
  consultarObligaciones 
} = atmService;

const {
  construirPayloadATM
} = atmService._test;

//const Adaptor = require('../../utils/ultravox_s2s');
const storage = require('./../../utils/storage');
const convertirNumeroATexto = require('./../../utils/numero-a-texto');

const service = ({ logger, callService }) => {
  const svc = callService;

  svc.on('session:new', async (session) => {

    if (session.status && session.status !== 200 && session.status !== 183) {
    logger.warn(`Cortando sesión por status no válido (${session.status})`);
    return session.hangup().send(); // Evita continuar
  }
    globalThis.transcripcionesATM = {};
    globalThis.promptsATM = {};
    const v_to = session.to;
    const v_parts = v_to.split(':')[1].split('@')[0];
    const telefono = v_parts.startsWith('7757') ? v_parts.slice(4) : v_parts;

    console.log("telefono", telefono);
    const datos = await storage.get(`callinfo:${telefono}`);
    console.log("datos", datos);

    const call_sid = session.call_sid;
    if (!call_sid) {
      logger.error('No se recibió call_sid en la sesión');
      return session.hangup().send();
    }

    session.locals = {
      logger: logger.child({ call_sid }),
      call_sid,
      identificacion: datos.identificacion,
      telefono,
      startTime: Date.now()
    };

    

    yardMaster.addSession(call_sid);
    logger.info(`[CALL] Nueva llamada entrante call-handler: ${call_sid}`);

    try {
      const acuerdo = null; 

      const token = await obtenerTokenATM();
      console.log("token", token);
      console.log("identificacion", session.locals.identificacion);
      let obligaciones = await storage.get(`obligaciones:${call_sid}`);

      if (!obligaciones) {
        const token = await obtenerTokenATM(); // Opcional: si consultarObligaciones ya lo obtiene internamente
        obligaciones = await consultarObligaciones(session.locals.identificacion);
        await storage.set(`obligaciones:${call_sid}`, obligaciones);
      }

      console.log("obligaciones", obligaciones);

      //const adaptor = new Adaptor(session.locals.logger, process.env.ULTRAVOX_API_KEY);
      //session.locals.adaptor = adaptor;

      //const apiKey = process.env.ULTRAVOX_API_KEY;
      //if (!apiKey) throw new Error('ULTRAVOX_API_KEY no configurada');

      const parseDecimal = (str) => {
        if (typeof str !== 'string') return str;
        return parseFloat(str.replace(/,/g, '').replace(/\s+/g, '').trim());
      };
      const pronunciarDigitos = (numeroStr) => {
        return String(numeroStr).split('').join(', ');
      };

      //adaptor.on('ready', () => {
      //  session.locals.logger.info('Adaptador Ultravox listo');
      //  adaptor.setOutgoingJambonzSocket(session.ws);
      //});

      //adaptor.setIncomingJambonzSocket(session.ws);

      session
        .on('/event', onEvent.bind(null, session))
        .on('/toolCall', onToolCall.bind(null, session))
        .on('/final', onFinal.bind(null, session))
        .on('/sip_referAction', sipReferAction.bind(null, session))
        .on('/sip_referEvent', sipReferEvent.bind(null, session))
        .on('call:status', onCallStatus.bind(null, session))
        .on('close', onClose.bind(null, session))
        .on('error', onError.bind(null, session));

      const prompt = globalThis.promptsATM?.[telefono] || 'Hola, soy Andrea del área de cobranza de Claro.';

      const formatObligaciones = (obligaciones) => {
        return obligaciones.map((ob, index) => {
          const cuenta = pronunciarDigitos(ob.cuenta);
          const valorNumerico = parseDecimal(ob.mod_init_cta);
          const valorEnLetras = convertirNumeroATexto(valorNumerico);
          const vencimiento = new Date(ob.fecha_vencimiento).toLocaleDateString('es-CO');
          const mora = ob.dias_mora > 365 
            ? `${Math.floor(ob.dias_mora/365)} años y ${ob.dias_mora%365} días` 
            : `${ob.dias_mora} días`;
          return `
Obligación ${index + 1}:
- Producto: ${ob.origen} (${ob.tipo_obligacion})
- Número: ${cuenta}
- Valor adeudado: $${valorEnLetras}
- Fecha de vencimiento: ${vencimiento}
- Días en mora: ${mora}
- Plan: ${ob.plan || 'No especificado'}
`.trim();
        }).join('\n\n');
      };

      const buildSystemPrompt = (identificacion, obligaciones) => {
        const cliente = obligaciones[0]?.nombrecompleto || 'Estimado cliente';
        const deudaTotal = obligaciones.reduce((sum, ob) => sum + parseFloat(ob.mod_init_cta), 0);
        //const deudaTotalEnLetras = convertirNumeroATexto(parseFloat(deudaTotal));
        const cuenta = obligaciones[0]?.cuenta || 'XXXXXXXX';
        const cuentaEnDigitos = cuenta.split('').join(', ');

       // const _valorNumerico = parseDecimal(deudaTotal);
        //const deudaTotalEnLetras = convertirNumeroATexto(_valorNumerico);

         const deudaTotalNumerico = obligaciones.reduce((sum, ob) => sum + parseFloat(ob.mod_init_cta), 0);
         const deudaTotalEnLetras = convertirNumeroATexto(deudaTotalNumerico);
        
       // const deudaTotalEnLetras = convertirNumeroATexto(`$${deudaTotal}`);
       // console.log(deudaTotalEnLetras);
        const acuerdoTexto = acuerdo
        ? `\n\nCONFIRMACIÓN DEL ACUERDO:\n${confirmarAcuerdo(acuerdo.fecha, acuerdo.valor, acuerdo.referencia)}`
        : '';
        return`
ROLE: Eres Andrea, agente especializada en cobranza de Claro. Tu estilo es:
- Empático pero profesional y directa no repite mucho y va directo a la cobranza
- Clara en la comunicación
- Persuasiva pero no agresiva
- Cuando hagas una pregunta como nombre, numero de cuenta espera a que te haga la respuesta si es positivo continua si es negativo encierra la   llamada
- Orientada a soluciones
- Buena pronunciacion de numeros
- Cuando leas numeros, pronuncia de forma muy pausada

CONTEXTO:
Estás contactando a ${cliente} cuyo número de cuenta es: ${cuentaEnDigitos}, quien tiene ${obligaciones.length} obligaciones vencidas por un total de $${deudaTotalEnLetras}.

DETALLE DE OBLIGACIONES:
${formatObligaciones(obligaciones)}

INSTRUCCIONES:
1 Cuando hagas una pregunta como nombre, numero de cuenta espera a que te haga la respuesta si es positivo continua si es negativo encierra la   llamada
2. Saluda cordialmente y confirma que hablas con ${cliente.split(' ')[1] || 'el cliente'}
3. Menciona el motivo de tu llamada: "Le llamo acerca de sus obligaciones vencidas con Claro"
4. Destaca la más urgente (la que tiene más días en mora)
5. Ofrece alternativas de pago (pago total)
6. Usa lenguaje sencillo y evita términos técnicos, nunca menciones lugares fisicos de pagos, solo virtuales
7. Mantén la conversación fluida y profesional
8. Mantén la conversación fluida y profesional. ${acuerdoTexto}
9. Antes de continuar, valida si estás hablando con el titular de la cuenta (nombre: ${cliente}) o con el encargado de realizar los pagos, los pagos solamente por el app o la web de Claro.
10. Cuando leas números, usa pausas naturales. No escribas ni digas la palabra “pausa”. Sólo separa con comas o lee los dígitos lentamente.
11. Tienes que preguntas si acepta el acuerdo, si acepta de forma positiva prosigue si es negativo corta la llamada
12. Siempre Tienes que dar el numero de cuenta para la identificacion de cualquier llamada.
`.trim();
      };

      const fullSystemPrompt = buildSystemPrompt(session.locals.identificacion, obligaciones);
      console.log("texto",fullSystemPrompt);
      session.config({
        listen: {
          enable: true,
          url: `${process.env.WS_BASE_URL}/audio-stream?callSid=${session.locals.call_sid}`,
          mixType: 'mono',
          sampleRate: 8000,
          bidirectionalAudio: {
            enabled: true,
            streaming: true,
            sampleRate: 8000
          }
        }
      });

      session.llm({
        vendor: 'ultravox',
        model: 'fixie-ai/ultravox',
        auth: { apiKey: process.env.ULTRAVOX_API_KEY },
        actionHook: '/final',
        eventHook: '/event',
        toolHook: '/toolCall',
        llmOptions: {
          systemPrompt: fullSystemPrompt,
          firstSpeaker: 'FIRST_SPEAKER_AGENT',
          initialMessages: [{
            medium: 'MESSAGE_MEDIUM_VOICE',
            role: 'MESSAGE_ROLE_AGENT',
            text: prompt
          }],
          model: 'fixie-ai/ultravox',
          voice: 'Andrea-Spanish',
          transcriptOptional: true
        }
      }).send();
    } catch (err) {
      session.locals.logger.error({ 
        error: err.message,
        stack: err.stack 
      }, 'Error en inicialización de llamada');

      if (yardMaster.hasSession(call_sid)) {
        safeClose(session.locals.logger, call_sid);
      }
      session.close();
    }

    console.log("conseguiste casi");
  });

  return svc;
};

// Handlers (se mantienen iguales que antes)
const onEvent = async (session, evt) => {
  const { logger } = session.locals;
  logger.info({ evt }, 'Evento recibido en /event');
  const telefono = session.locals.telefono;

  /*if (evt.type === 'transcript' && evt.role === 'agent' && evt.final) {
    globalThis.transcripcionesATM[telefono] = globalThis.transcripcionesATM[telefono] || [];
    globalThis.transcripcionesATM[telefono].push(evt);
  }*/
  
  if (evt.type === 'transcript' && evt.final) {
   globalThis.transcripcionesATM[telefono] = globalThis.transcripcionesATM[telefono] || [];
   // Guardamos TODO y luego filtramos por rol en atm-service
   globalThis.transcripcionesATM[telefono].push({
     role: evt.role, text: evt.text, final: true
   });
}

  session.reply();
};

const onToolCall = async (session, evt) => {
  const { logger } = session.locals;
  const { tool_call_id } = evt;
  logger.info({ evt }, 'Tool hook recibido');

  try {
    const data = {
      type: 'client_tool_result',
      invocation_id: tool_call_id,
      result: 'Operación realizada correctamente'
    };
    session.sendToolOutput(tool_call_id, data);
  } catch (err) {
    logger.error({ err }, 'Error enviando resultado de herramienta');
  }
};

async function onFinal(session, evt) {

  const normalizePhone = (raw) => String(raw).replace(/[+\s-]/g,'').replace(/^57(?=\d{10}$)/,'');
  const { logger, telefono, identificacion, startTime } = session.locals;
  let payload; // Declaramos payload fuera del try para que esté disponible en el catch
  
  try {
    const duracionSegundos = Math.floor((Date.now() - startTime) / 1000);
    const transcripciones = globalThis.transcripcionesATM?.[telefono] || [];
    
    // Limpiar las transcripciones después de usarlas
    if (globalThis.transcripcionesATM?.[telefono]) {
      delete globalThis.transcripcionesATM[telefono];
    }

    logger.debug('Preparando para consultar obligaciones', { identificacion });
    const obligaciones = await storage.get(`obligaciones:${session.call_sid}`); //await consultarObligaciones(identificacion);
    /*logger.debug('Obligaciones obtenidas:', { 
      count: obligaciones.length,
      sample: obligaciones.length > 0 ? obligaciones[0] : null 
    });*/

   const count = Array.isArray(obligaciones) ? obligaciones.length : 0;
 const sample = count > 0 ? obligaciones[0] : null;
 logger.debug('Obligaciones obtenidas:', { count, sample });
 if (count === 0) {
   logger.warn('No se encontraron obligaciones en Redis para esta llamada');
   return session.close();
 }

    if (!Array.isArray(obligaciones) || obligaciones.length === 0) {
      logger.warn('No se encontraron obligaciones en Redis para esta llamada');
      return session.close();
    }
   
    payload = construirPayloadATM({ // Ahora asignamos a la variable ya declarada
      telefono: String(telefono),
      identificacion: String(identificacion),
      duracionSegundos,
      transcripciones,
      cuentas: obligaciones,
      metadata: {
        motivonopago: '42'
      }
    });

    logger.info('Payload para ATM:', {
      metadata: {
        perfil: payload.perfil,
        cuentaCount: payload.cuenta?.length || 0,
        gestionLength: payload.gestion?.length || 0,
        tieneAcuerdo: !!payload.fechapromesa,
        duracionLlamada: `${duracionSegundos} segundos`
      },
      payloadCompleto: payload
    });

    logger.info('Enviando payload a ATM...');
    await enviarResultadoATM(payload);
    logger.info('Resultado enviado a ATM correctamente');

      // ✅ marcar conversación exitosa para el scheduler
   try {
      const fono = normalizePhone(telefono);
      await storage.del(`call_pending:${fono}`);
      await storage.set(`call_success:${fono}`, true, { ttl: 60 * 60 * 24 });
    } catch (e) {
     logger.warn({ e }, 'No se pudo marcar call_success/limpiar call_pending');
    }
  } catch (error) {
    logger.error({ 
      error: {
        message: error.message,
        stack: error.stack,
        code: error.code
      },
      response: error.response?.data,
      telefono,
      identificacion,
      lastPayload: payload // Ahora payload está definido aquí
    }, console.log(payload), 'Error al enviar resultado a ATM');
  } finally {
    if (session.ws?.readyState === 1) {
      session.close();
    }
  }
};

const onCallStatus = async (session, evt) => {
  const { logger } = session.locals;
  logger.info({ evt }, 'Estado de llamada');

 /* const estado = evt.call_status;
  if (estado && estado !== 'answered' && estado !== 'completed') {
    logger.warn(`Call_status inválido (${estado}), cortando sesión`);
    session.hangup().send();  // Aquí SÍ puedes colgar porque tienes acceso a session
    return;
  }*/

const estado = evt.call_status;
 // Procesa sólo estados terminales/errores conocidos; ignora transitorios
 const terminales = new Set(['completed','failed','busy','no-answer','declined','canceled']);
 /*if (terminales.has(estado)) {
      logger.warn(`Estado terminal (${estado}), cerrando sesión`);
   return session.hangup().send();
  }*/
  
  if (terminales.has(estado)) {
  logger.warn(`Estado terminal (${estado}), finalizando y cerrando sesión`);
  try {
    await onFinal(session, { type: 'call_status', estado });
  } catch (e) {
    logger.error({ e }, 'onFinal falló en estado terminal');
  }
  return session.hangup().send();
}


  if (!session.locals.call_sid_b && evt.direction === 'outbound') {
    session.locals.call_sid_b = evt.call_sid;
  }
};

const sipReferAction = async (session, evt) => {
  const { logger } = session.locals;
  logger.info({ evt }, '[SIP] REFER Action');
};

const sipReferEvent = async (session, evt) => {
  const { logger } = session.locals;
  logger.info({ evt }, '[SIP] REFER Event');
};

const onClose = (session, code, reason) => {
  const { logger } = session.locals;
  logger.info({ code, reason }, 'Sesión cerrada');

  if (!session.locals.call_sid) {
    logger.warn('Intento de cerrar sesión sin call_sid, ignorado');
    return;
  }

  detenerEjecucionLlamadas();
  safeClose(logger, session.call_sid);
};

const onError = (session, err) => {
  const { logger } = session.locals;
  logger.error({ err }, 'Error en sesión');
  safeClose(logger, session.call_sid);
};

module.exports = service;