// routes/ws/monitor.js

const { publish, addWS } = require('../../utils/monitor-hub');



module.exports = function ({ logger, wssStream }) {

  wssStream.on('connection', (ws, req) => {

    const { pathname, searchParams } = new URL(req.url, `http://${req.headers.host}`);

    if (pathname !== '/monitor') return;



    const ui = searchParams.get('ui') || 'web';

    logger.info({ ui }, 'Nuevo monitor conectado');

    addWS(ws, { ui });



    // saludo

   // ws.send(JSON.stringify({ type:'connected', ts: Date.now(), ui: searchParams.get('ui')||'web' }));

    logger.info('Monitor conectado');

  });

};



// helper para que otros módulos emitan

module.exports.emit = (evt) => publish(evt);
