require('dotenv').config();
const fs = require('fs');
const path = require('path');
const csv = require('csv-parser');
const jambonz = require('@jambonz/node-client');
const client = jambonz(process.env.JAMBONZ_ACCOUNT_SID, process.env.JAMBONZ_API_KEY, {
  baseUrl: process.env.JAMBONZ_BASE_URL
});

const CONTACTS_FILE = path.join(__dirname, '../data/contactos.csv');

let detenerLlamadas = false;

const normalizePhone = (raw) => {
  let phone = raw.replace(/\+|\s|-/g, '');
  if (phone.startsWith('57') && phone.length > 10) phone = phone.substring(2);
  return phone;
};

const launchCall = async (contact) => {
  const numero = normalizePhone(contact.telefono);

  const payload = {
    application_sid: process.env.APPLICATION_SID,
    from: 'bot4tm',
    to: {
      type: 'sip',
      sipUri: `sip:7757${numero}@atmbponextcall.controlnextapp.com`
    },
    call_hook: {
      url: `${process.env.WS_BASE_URL}/call`, // <-- importante que sea HTTP
      method: 'GET'
    },
    call_status_hook: {
      url: `${process.env.HTTP_BASE_URL}/status`,
      method: 'POST'
    },
    speech_synthesis_vendor: 'google',
    speech_synthesis_language: 'es-US',
    speech_synthesis_voice: 'es-US-Standard-A',
    speech_recognizer_vendor: 'google',
    speech_recognizer_language: 'es-CO'
  };

  try {
    const response = await client.calls.create(payload);
    console.log(` Llamando a ${numero} - call_sid: ${response.sid}`);
  } catch (err) {
    console.error(`Error al llamar a ${numero}:`, err.message || err);
  }
};

const ejecutarLlamadas = async () => {
  return new Promise((resolve, reject) => {
    fs.createReadStream(CONTACTS_FILE)
      .pipe(csv())
      .on('data', async (row) => {
        if (detenerLlamadas) {
          console.log(' Se detuvo la ejecución de llamadas.');
          return resolve();
        }

        const camposRequeridos = [
          'telefono', 'nombre', 'deuda', 'fecha_vencimiento',
          'cuenta', 'referencia_pago', 'crm', 'dias_mora', 'plazo_acuerdo'
        ];

        if (camposRequeridos.every(f => row[f] && row[f].trim() !== '')) {
          await launchCall(row);
          await new Promise(res => setTimeout(res, 2000));
        } else {
          console.log(` Contacto inválido: ${JSON.stringify(row)}`);
        }
      })
      .on('end', () => {
        console.log(' Llamadas programadas completadas.');
        resolve();
      })
      .on('error', reject);
  });
};

const detenerEjecucionLlamadas = () => {
  detenerLlamadas = true;
  console.log(' Se marcó bandera para detener ejecución.');
};

module.exports = {
  ejecutarLlamadas,
  detenerEjecucionLlamadas
};
