const ffmpeg = require('fluent-ffmpeg');
const path = require('path');
const fs = require('fs');

class AudioUtils {
  /**
   * Convierte un archivo RAW a WAV.
   * @param {string} rawFilePath - Ruta del archivo RAW.
   * @param {function} callback - Callback con (err, outputPath).
   */
  static convertRawToWav(rawFilePath, callback) {
    if (!fs.existsSync(rawFilePath)) {
      return callback(new Error(`Archivo no encontrado: ${rawFilePath}`));
    }

    const outputPath = rawFilePath.replace(/\.raw$/, '.converted.wav');

    ffmpeg()
      .input(rawFilePath)
      .inputFormat('s16le')  // PCM 16-bit little endian
      .audioFrequency(8000)
      .audioChannels(1)
      .audioCodec('pcm_s16le')
      .format('wav')
      .on('end', () => callback(null, outputPath))
      .on('error', (err) => callback(err))
      .save(outputPath).run();
  }

  /**
   * Verifica si un buffer está compuesto únicamente de ruido blanco (0xFF).
   * @param {Buffer} buffer - El buffer a analizar.
   * @returns {boolean} - `true` si es solo ruido blanco.
   */
  
static isWhiteNoise(buffer) {
    if (!Buffer.isBuffer(buffer)) return false;
  
    // Verifica si todos los bytes son 0xFF o 0x00
    // Puedes ajustar la lógica según el tipo de ruido que estés viendo
    return buffer.every(byte => byte === 0xFF || byte === 0x00);
  }
}

module.exports = AudioUtils;

