const { construirPayloadATM } = require('./post-llamada');
const { enviarResultadoATM } = require('../services/atm-service');

app.post('/final', async (req, res) => {
  try {
    const { telefono, identificacion, duracion, transcripciones } = req.body;

    if (!telefono || !identificacion || !duracion) {
      return res.status(400).json({ error: 'Faltan datos en la petición.' });
    }

    const cuentasATM = globalThis.cuentasATM?.[telefono] || [];

    const payload = construirPayloadATM({
      telefono,
      identificacion,
      duracionSegundos: duracion,
      transcripciones,
      cuentasATM
    });

    const resultado = await enviarResultadoATM(payload);
    console.log('✅ Resultado enviado a ATM:', resultado);
    res.sendStatus(200);
  } catch (err) {
    console.error('❌ Error en /final:', err.message);
    res.status(500).json({ error: 'Error procesando resultado final.' });
  }
});
