// file: utils/safe-close.js
const yardMaster = require('./yardmaster');

/**
 * safeClose: Cierra sesión activa si existe
 */
const safeClose = (logger, sessionId) => {
  try {
    if (yardMaster.hasSession(sessionId)) {
      yardMaster.close(sessionId);
      logger.info(`safeClose: sesión cerrada correctamente para ${sessionId}`);
    } else {
      logger.warn(`safeClose: no se encontró sesión activa para ${sessionId}`);
    }
  } catch (err) {
    logger.error({ err }, `safeClose: error al cerrar sesión ${sessionId}`);
  }
};

module.exports = safeClose;

/**
 /utils/safe-close.js
 */
/*const safeClose = (logger, sessionId) => {
    try {
      const yardMaster = require('./yardmaster');
      
      // Check if the session exists before attempting to close
      if (yardMaster.hasSession(sessionId)) {
        yardMaster.close(sessionId);
      } else {
        logger.warn(`No session to close: ${sessionId}`);
      }
    } catch (err) {
        logger.info({err}, `Error safely closing session ${sessionId}`);
    }
  };
  
  module.exports = safeClose;*/
  