const Redis = require('ioredis');
const logger = require('./logger')('storage');

class Storage {
  constructor() {
    if (process.env.REDIS_URL) {
      this.client = new Redis(process.env.REDIS_URL);
      logger.info('Usando Redis para almacenamiento');
    } else {
      logger.warn('Usando memoria volátil (solo para desarrollo)');
      this.cache = new Map();
    }
  }

  async set(callSid, data) {
    if (this.client) {
      await this.client.setex(`call:${callSid}`, 86400, JSON.stringify(data)); // 24h
    } else {
      this.cache.set(`call:${callSid}`, data);
    }
  }
  
async get(callSid) {
  const key = `call:${callSid}`;
  if (this.client) {
    logger.debug(`Buscando clave en Redis: ${key}`);
    const data = await this.client.get(key);
    logger.debug(`Datos encontrados: ${data ? 'Sí' : 'No'}`);
    return data ? JSON.parse(data) : null;
  }
  logger.debug(`Buscando clave en cache: ${key}`);
  return this.cache.get(key) || null;
}

  async del(callSid) {
    if (this.client) {
      await this.client.del(`call:${callSid}`);
    } else {
      this.cache.delete(`call:${callSid}`);
    }
  }
}

module.exports = new Storage();