// file: utils/ws-pending-queue.js
/**
 * pending-queue: almacena sockets que llegan antes de que sesión exista
 */
const pendingSockets = new Map();

function addPendingSocket(callSid, ws) {
  if (!pendingSockets.has(callSid)) {
    pendingSockets.set(callSid, []);
  }
  pendingSockets.get(callSid).push(ws);
}

function consumePendingSockets(callSid) {
  const sockets = pendingSockets.get(callSid) || [];
  pendingSockets.delete(callSid);
  return sockets;
}

module.exports = {
  addPendingSocket,
  consumePendingSockets
};
